/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.StateIngredientBlock;
import vazkii.botania.common.crafting.StateIngredientBlockState;
import vazkii.botania.common.crafting.StateIngredientBlocks;

public class StateIngredientCompound
implements StateIngredient {
    protected final ImmutableSet<StateIngredient> ingredients;
    protected final Set<BlockState> resolvedBlocks;

    public StateIngredientCompound(Collection<StateIngredient> ingredients) {
        this.ingredients = ImmutableSet.copyOf(ingredients);
        this.resolvedBlocks = new HashSet<BlockState>();
    }

    @Override
    public boolean test(BlockState state) {
        return this.ingredients.stream().anyMatch(stateIngredient -> stateIngredient.test(state));
    }

    @Override
    public BlockState pick(Random random) {
        return new ArrayList<BlockState>(this.getBlocks()).get(random.nextInt(this.getBlocks().size()));
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "compound");
        JsonArray array = new JsonArray();
        for (StateIngredient ingredient : this.ingredients) {
            array.add((JsonElement)ingredient.serialize());
        }
        object.add("ingredients", (JsonElement)array);
        return object;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        ImmutableList ingredients = this.ingredients.asList();
        buffer.m_130130_(3);
        buffer.m_130130_(ingredients.size());
        for (StateIngredient ingredient : ingredients) {
            ingredient.write(buffer);
        }
    }

    @Override
    public List<ItemStack> getDisplayedStacks() {
        return this.getBlocks().stream().map(BlockBehaviour.BlockStateBase::m_60734_).filter(b -> b.m_5456_() != Items.f_41852_).map(ItemStack::new).collect(Collectors.toList());
    }

    @Override
    public List<BlockState> getDisplayed() {
        return new ArrayList<BlockState>(this.getBlocks());
    }

    @Nonnull
    protected Set<BlockState> getBlocks() {
        if (this.resolvedBlocks.isEmpty()) {
            for (StateIngredient ingredient : this.ingredients) {
                if (ingredient instanceof StateIngredientBlock) {
                    StateIngredientBlock stateIngredient = (StateIngredientBlock)ingredient;
                    this.resolvedBlocks.add(stateIngredient.getBlock().m_49966_());
                    continue;
                }
                if (ingredient instanceof StateIngredientBlockState) {
                    StateIngredientBlockState stateIngredient = (StateIngredientBlockState)ingredient;
                    this.resolvedBlocks.add(stateIngredient.getState());
                    continue;
                }
                if (!(ingredient instanceof StateIngredientBlocks)) continue;
                StateIngredientBlocks stateIngredient = (StateIngredientBlocks)ingredient;
                this.resolvedBlocks.addAll(stateIngredient.getBlocks().stream().map(Block::m_49966_).toList());
            }
        }
        return this.resolvedBlocks;
    }

    public ImmutableSet<StateIngredient> getIngredients() {
        return this.ingredients;
    }

    public String toString() {
        return "StateIngredientCompound{" + this.getIngredients() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateIngredientCompound that = (StateIngredientCompound)o;
        return Objects.equals(this.ingredients, that.ingredients);
    }

    public int hashCode() {
        return this.ingredients != null ? this.ingredients.hashCode() : 0;
    }
}

